/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.IOException;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBMPString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERBMPString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)object;
        return this.getString().equals(dERBMPString.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[2 * i] = (byte)(cArray[i] >> 8);
            byArray[2 * i + 1] = (byte)cArray[i];
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

