/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import sun.java2d.ProxyGraphics2D;

public abstract class PathGraphics
extends ProxyGraphics2D {
    private Printable mPainter;
    private PageFormat mPageFormat;
    private int mPageIndex;

    protected PathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        super(graphics2D, printerJob);
        this.mPainter = printable;
        this.mPageFormat = pageFormat;
        this.mPageIndex = n;
    }

    protected Printable getPrintable() {
        return this.mPainter;
    }

    protected PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    protected int getPageIndex() {
        return this.mPageIndex;
    }

    public abstract void redrawRegion(Rectangle2D var1, double var2, double var4, Rectangle2D var6, AffineTransform var7) throws PrinterException;

    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4), this.getBackground());
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            float f = nArray[0];
            float f2 = nArray2[0];
            int n2 = 1;
            while (n2 < n) {
                float f3 = nArray[n2];
                float f4 = nArray2[n2];
                this.draw(new Line2D.Float(f, f2, f3, f4));
                f = f3;
                f2 = f4;
                ++n2;
            }
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        if (string.length() == 0) {
            return;
        }
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.fill(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.fill(shape);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public void fill(Shape shape) {
        Paint paint = this.getPaint();
        try {
            this.fill(shape, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fill(Shape shape, Color color) {
        AffineTransform affineTransform = this.getTransform();
        this.deviceClip(this.getClip().getPathIterator(affineTransform));
        this.deviceFill(shape.getPathIterator(affineTransform), color);
    }

    protected abstract void deviceFill(PathIterator var1, Color var2);

    protected abstract void deviceClip(PathIterator var1);
}

