/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class BasicTextPaneUI
extends BasicEditorPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTextPaneUI();
    }

    protected String getPropertyPrefix() {
        return "TextPane";
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.getComponent();
        return jEditorPane.getEditorKit();
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        StyledDocument styledDocument = (StyledDocument)this.getComponent().getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("foreground")) {
            Color color = (Color)propertyChangeEvent.getNewValue();
            if (color != null) {
                StyleConstants.setForeground(style, color);
            } else {
                style.removeAttribute(StyleConstants.Foreground);
            }
        } else if (string.equals("font")) {
            Font font = (Font)propertyChangeEvent.getNewValue();
            if (font != null) {
                StyleConstants.setFontFamily(style, font.getName());
                StyleConstants.setFontSize(style, font.getSize());
                StyleConstants.setBold(style, font.isBold());
                StyleConstants.setItalic(style, font.isItalic());
            } else {
                style.removeAttribute(StyleConstants.FontFamily);
                style.removeAttribute(StyleConstants.FontSize);
                style.removeAttribute(StyleConstants.Bold);
                style.removeAttribute(StyleConstants.Italic);
            }
        }
    }
}

