/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.peer.FramePeer;
import sun.awt.im.InputMethodManager;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WFramePeer
extends WWindowPeer
implements FramePeer {
    public native void setState(int var1);

    public native int getState();

    public void reshape(int n, int n2, int n3, int n4) {
        this.reshapeFrame(n, n2, n3, n4);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(WWindowPeer.getSysMinWidth(), WWindowPeer.getSysMinHeight());
        if (((Frame)this.target).getMenuBar() != null) {
            dimension.height += WFramePeer.getSysMenuHeight();
        }
        return dimension;
    }

    public void setIconImage(Image image) {
        if (image == null) {
            this.setIconImageFromIntRasterData(null, null, 0, 0, 0);
        } else {
            int n;
            ColorModel colorModel;
            Object object;
            int n2 = WFramePeer.getSysIconWidth();
            int n3 = WFramePeer.getSysIconHeight();
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics graphics = bufferedImage.getGraphics();
            try {
                if (image instanceof WImage) {
                    object = ((WImage)image).getImageRep();
                    ((ImageRepresentation)object).reconstruct(32);
                }
                graphics.drawImage(image, 0, 0, n2, n3, null);
                colorModel = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                graphics.dispose();
                throw throwable;
            }
            object = bufferedImage.getRaster();
            DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
            colorModel = bufferedImage.getColorModel();
            byte[] byArray = new byte[n2 * n3 + 0];
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            n4 = 0;
            n5 = 0;
            while (n4 < dataBuffer.getSize() && n5 < byArray.length) {
                byte by = 0;
                n = 0;
                while (n < 8 && n4 < dataBuffer.getSize()) {
                    if (colorModel.getAlpha(dataBuffer.getElem(n4++)) == 0) {
                        bl = true;
                        by = (byte)(by | 1);
                    } else {
                        by = (byte)(by & 0xFFFFFFFE);
                    }
                    if (n < 7) {
                        by = (byte)(by << 1);
                    }
                    ++n;
                }
                byArray[n5] = by;
                ++n5;
            }
            if (!bl) {
                byArray = null;
            }
            n = ((Raster)object).getWidth();
            if (object instanceof IntegerComponentRaster) {
                n = ((IntegerComponentRaster)object).getScanlineStride();
            }
            this.setIconImageFromIntRasterData(((DataBufferInt)dataBuffer).getData(), byArray, n, ((Raster)object).getWidth(), ((Raster)object).getHeight());
        }
    }

    public void setMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = (WMenuBarPeer)WToolkit.targetToPeer(menuBar);
        this.setMenuBar0(wMenuBarPeer);
        this.updateInsets(this.insets_);
    }

    private native void setMenuBar0(WMenuBarPeer var1);

    WFramePeer(Frame frame) {
        super(frame);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void createAwtFrame(WComponentPeer var1);

    void create(WComponentPeer wComponentPeer) {
        this.createAwtFrame(wComponentPeer);
    }

    void initialize() {
        super.initialize();
        Frame frame = (Frame)this.target;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        this.setResizable(frame.isResizable());
        Image image = frame.getIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
    }

    private native void setIconImageFromIntRasterData(int[] var1, byte[] var2, int var3, int var4, int var5);

    private static native int getSysIconWidth();

    private static native int getSysIconHeight();

    private static native int getSysMenuHeight();

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }
}

