/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Reference indexedPropertyTypeRef;
    private Reference indexedReadMethodRef;
    private Reference indexedWriteMethodRef;
    private String indexedReadMethodName;
    private String indexedWriteMethodName;

    public IndexedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        this(string, clazz, "get" + FeatureDescriptor.capitalize(string), "set" + FeatureDescriptor.capitalize(string), "get" + FeatureDescriptor.capitalize(string), "set" + FeatureDescriptor.capitalize(string));
    }

    public IndexedPropertyDescriptor(String string, Class clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.indexedReadMethodName = string4;
        if (string4 != null && this.getIndexedReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + string4);
        }
        this.indexedWriteMethodName = string5;
        if (string5 != null && this.getIndexedWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + string5);
        }
        this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        this.setIndexedReadMethod0(method3);
        this.setIndexedWriteMethod0(method4);
        this.setIndexedPropertyType(this.findIndexedPropertyType(method3, method4));
    }

    public synchronized Method getIndexedReadMethod() {
        Method method = this.getIndexedReadMethod0();
        if (method == null) {
            Class[] classArray;
            Class clazz = this.getClass0();
            if (clazz == null || this.indexedReadMethodName == null && this.indexedReadMethodRef == null) {
                return null;
            }
            if (this.indexedReadMethodName == null) {
                classArray = this.getIndexedPropertyType0();
                this.indexedReadMethodName = classArray == Boolean.TYPE || classArray == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            classArray = new Class[]{Integer.TYPE};
            try {
                method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray);
            }
            catch (Exception exception) {
                method = null;
            }
            if (method == null) {
                this.indexedReadMethodName = "get" + this.getBaseName();
                try {
                    method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray);
                }
                catch (Exception exception) {
                    method = null;
                }
            }
            this.setIndexedReadMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedReadMethod(Method method) throws IntrospectionException {
        this.setIndexedPropertyType(this.findIndexedPropertyType(method, this.getIndexedWriteMethod0()));
        this.setIndexedReadMethod0(method);
    }

    private void setIndexedReadMethod0(Method method) {
        if (method == null) {
            this.indexedReadMethodName = null;
            this.indexedReadMethodRef = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedReadMethodName = method.getName();
        this.indexedReadMethodRef = FeatureDescriptor.createReference(method);
    }

    public synchronized Method getIndexedWriteMethod() {
        Method method = this.getIndexedWriteMethod0();
        if (method == null) {
            Class clazz = this.getClass0();
            if (clazz == null || this.indexedWriteMethodName == null && this.indexedWriteMethodRef == null) {
                return null;
            }
            Class clazz2 = this.getIndexedPropertyType0();
            if (clazz2 == null) {
                try {
                    clazz2 = this.findIndexedPropertyType(this.getIndexedReadMethod(), null);
                    this.setIndexedPropertyType(clazz2);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            if (this.indexedWriteMethodName == null) {
                this.indexedWriteMethodName = "set" + this.getBaseName();
            }
            try {
                Class[] classArray;
                if (clazz2 == null) {
                    classArray = null;
                } else {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Integer.TYPE;
                    classArray = classArray2;
                    classArray2[1] = clazz2;
                }
                method = Introspector.findMethod(clazz, this.indexedWriteMethodName, 2, classArray);
            }
            catch (Exception exception) {
                method = null;
            }
            this.setIndexedWriteMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedWriteMethod(Method method) throws IntrospectionException {
        Class clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), method);
        this.setIndexedPropertyType(clazz);
        this.setIndexedWriteMethod0(method);
    }

    private void setIndexedWriteMethod0(Method method) {
        if (method == null) {
            this.indexedWriteMethodName = null;
            this.indexedWriteMethodRef = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedWriteMethodName = method.getName();
        this.indexedWriteMethodRef = FeatureDescriptor.createReference(method);
    }

    public synchronized Class getIndexedPropertyType() {
        Class clazz = this.getIndexedPropertyType0();
        if (clazz == null) {
            try {
                clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
                this.setIndexedPropertyType(clazz);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private void setIndexedPropertyType(Class clazz) {
        this.indexedPropertyTypeRef = FeatureDescriptor.createReference(clazz);
    }

    private Class getIndexedPropertyType0() {
        return (Class)FeatureDescriptor.getObject(this.indexedPropertyTypeRef);
    }

    private Method getIndexedReadMethod0() {
        return (Method)FeatureDescriptor.getObject(this.indexedReadMethodRef);
    }

    private Method getIndexedWriteMethod0() {
        return (Method)FeatureDescriptor.getObject(this.indexedWriteMethodRef);
    }

    private Class findIndexedPropertyType(Method method, Method method2) throws IntrospectionException {
        Object object;
        Object object2 = null;
        if (method != null) {
            object = method.getParameterTypes();
            if (((Class[])object).length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            object2 = method.getReturnType();
            if (object2 == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (method2 != null) {
            object = method2.getParameterTypes();
            if (((Class[])object).length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (object2 != null && object2 != object[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods: " + this.getName());
            }
            object2 = object[1];
        }
        if (!((object = this.getPropertyType()) == null || ((Class)object).isArray() && ((Class)object).getComponentType() == object2)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods: " + this.getName());
        }
        return object2;
    }

    IndexedPropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        Method method;
        Method method2;
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            try {
                method2 = indexedPropertyDescriptor.getIndexedReadMethod();
                if (method2 != null) {
                    this.setIndexedReadMethod(method2);
                }
                if ((method = indexedPropertyDescriptor.getIndexedWriteMethod()) != null) {
                    this.setIndexedWriteMethod(method);
                }
            }
            catch (IntrospectionException introspectionException) {
                System.out.println("ERROR: read or write method not set for " + this.toString());
                System.out.println("Reason: " + introspectionException.getMessage());
            }
        }
        if (propertyDescriptor2 instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor2;
            try {
                method2 = indexedPropertyDescriptor.getIndexedReadMethod();
                if (method2 != null && method2.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedReadMethod(method2);
                }
                if ((method = indexedPropertyDescriptor.getIndexedWriteMethod()) != null && method.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedWriteMethod(method);
                }
            }
            catch (IntrospectionException introspectionException) {
                System.out.println("ERROR: read or write method not set for " + this.toString());
                System.out.println("Reason: " + introspectionException.getMessage());
            }
        }
    }

    IndexedPropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor) {
        super(indexedPropertyDescriptor);
        this.indexedReadMethodRef = indexedPropertyDescriptor.indexedReadMethodRef;
        this.indexedWriteMethodRef = indexedPropertyDescriptor.indexedWriteMethodRef;
        this.indexedPropertyTypeRef = indexedPropertyDescriptor.indexedPropertyTypeRef;
        this.indexedWriteMethodName = indexedPropertyDescriptor.indexedWriteMethodName;
        this.indexedReadMethodName = indexedPropertyDescriptor.indexedReadMethodName;
    }
}

