/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.peer.LabelPeer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Label
extends Component
implements Accessible {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String text;
    int alignment = 0;
    private static final String base = "label";
    private static int nameCounter;
    private static final long serialVersionUID = 3094126758329070636L;

    public Label() {
        this("", 0);
    }

    public Label(String string) {
        this(string, 0);
    }

    public Label(String string, int n) {
        this.text = string;
        this.setAlignment(n);
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createLabel(this);
            }
            super.addNotify();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setAlignment(n);
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + n);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        boolean bl = false;
        Label label = this;
        synchronized (label) {
            if (!(string == this.text || this.text != null && this.text.equals(string))) {
                this.text = string;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setText(string);
                }
                bl = true;
            }
        }
        if (bl && this.valid) {
            this.invalidate();
        }
    }

    protected String paramString() {
        String string = ",align=";
        switch (this.alignment) {
            case 0: {
                string = string + "left";
                break;
            }
            case 1: {
                string = string + "center";
                break;
            }
            case 2: {
                string = string + "right";
            }
        }
        return super.paramString() + string + ",text=" + this.text;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTLabel();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        Label.initIDs();
        nameCounter = 0;
    }

    protected class AccessibleAWTLabel
    extends Component.AccessibleAWTComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (Label.this.getText() == null) {
                return super.getAccessibleName();
            }
            return Label.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

