/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTPermission;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.security.action.LoadLibraryAction;

public abstract class Toolkit {
    private static java.awt.LightweightPeer lightweightMarker;
    private static Toolkit toolkit;
    private static ResourceBundle resources;
    private static boolean loaded;
    protected final Map desktopProperties = new HashMap();
    protected final PropertyChangeSupport desktopPropsSupport = new PropertyChangeSupport(this);
    private AWTEventListener eventListener = null;
    private WeakHashMap listener2SelectiveListener = new WeakHashMap();
    private AWTPermission listenToAllAWTEventsPermission = null;

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component component) {
        if (lightweightMarker == null) {
            lightweightMarker = new java.awt.LightweightPeer(component);
        }
        return lightweightMarker;
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] nArray) {
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    private static void loadAssistiveTechnologies() {
        final String string = File.separator;
        final Properties properties = new Properties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                try {
                    object = new File(System.getProperty("java.home") + string + "lib" + string + "accessibility.properties");
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = System.getProperty("javax.accessibility.screen_magnifier_present");
                if (object == null && (object = properties.getProperty("screen_magnifier_present", null)) != null) {
                    System.setProperty("javax.accessibility.screen_magnifier_present", (String)object);
                }
                return null;
            }
        });
        String string2 = properties.getProperty("assistive_technologies", null);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    Class clazz = classLoader != null ? classLoader.loadClass(string3) : Class.forName(string3);
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Assistive Technology not found: " + string3);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Assistive Technology: " + string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Assistive Technology: " + string3);
                }
                catch (Exception exception) {
                    throw new AWTError("Error trying to install Assistive Technology: " + string3 + " " + exception);
                }
            }
        }
    }

    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit == null) {
            try {
                Compiler.disable();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String string = null;
                        Class clazz = null;
                        try {
                            block8: {
                                string = System.getProperty("awt.toolkit", "sun.awt.motif.MToolkit");
                                try {
                                    clazz = Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block8;
                                    try {
                                        clazz = classLoader.loadClass(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        throw new AWTError("Toolkit not found: " + string);
                                    }
                                }
                            }
                            if (clazz != null) {
                                Toolkit.toolkit = (Toolkit)clazz.newInstance();
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            throw new AWTError("Could not instantiate Toolkit: " + string);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new AWTError("Could not access Toolkit: " + string);
                        }
                        return null;
                    }
                });
                Toolkit.loadAssistiveTechnologies();
                Object var1 = null;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                Compiler.enable();
                throw throwable;
            }
            Compiler.enable();
            {
            }
        }
        return toolkit;
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getPrintJob(frame, string, jobAttributes, pageAttributes);
        }
        return this.getPrintJob(frame, string, null);
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public boolean getLockingKeyState(int n) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
    }

    public void setLockingKeyState(int n, boolean bl) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.setLockingKeyState");
    }

    protected static Container getNativeContainer(Component component) {
        return component.getNativeContainer();
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, point, string);
        }
        return new Cursor(0);
    }

    public Dimension getBestCursorSize(int n, int n2) {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getBestCursorSize(n, n2);
        }
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getMaximumCursorColors();
        }
        return 0;
    }

    private static native void initIDs();

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    public static String getProperty(String string, String string2) {
        if (resources != null) {
            try {
                return resources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    static EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueueImpl();
    }

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        return null;
    }

    public final synchronized Object getDesktopProperty(String string) {
        Object object;
        if (this.desktopProperties.isEmpty()) {
            this.initializeDesktopProperties();
        }
        if ((object = this.desktopProperties.get(string)) == null && (object = this.lazilyLoadDesktopProperty(string)) != null) {
            this.setDesktopProperty(string, object);
        }
        return object;
    }

    protected final void setDesktopProperty(String string, Object object) {
        Object object2;
        Toolkit toolkit = this;
        synchronized (toolkit) {
            object2 = this.desktopProperties.get(string);
            this.desktopProperties.put(string, object);
        }
        this.desktopPropsSupport.firePropertyChange(string, object2, object);
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.desktopPropsSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.desktopPropsSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addAWTEventListener(AWTEventListener aWTEventListener, long l) {
        if (aWTEventListener == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener);
            if (selectiveAWTEventListener == null) {
                selectiveAWTEventListener = new SelectiveAWTEventListener(aWTEventListener, l);
                this.listener2SelectiveListener.put(aWTEventListener, selectiveAWTEventListener);
                this.eventListener = ToolkitEventMulticaster.add(this.eventListener, selectiveAWTEventListener);
            }
            selectiveAWTEventListener.orEventMasks(l);
        }
    }

    public void removeAWTEventListener(AWTEventListener aWTEventListener) {
        if (aWTEventListener == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener);
            if (selectiveAWTEventListener != null) {
                this.listener2SelectiveListener.remove(aWTEventListener);
            }
            this.eventListener = ToolkitEventMulticaster.remove(this.eventListener, selectiveAWTEventListener == null ? aWTEventListener : selectiveAWTEventListener);
        }
    }

    void notifyAWTEventListeners(AWTEvent aWTEvent) {
        AWTEventListener aWTEventListener = this.eventListener;
        if (aWTEventListener != null) {
            aWTEventListener.eventDispatched(aWTEvent);
        }
    }

    public abstract Map mapInputMethodHighlight(InputMethodHighlight var1);

    static {
        loaded = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    resources = ResourceBundle.getBundle("java.awt.resources.awt");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                return null;
            }
        });
        Toolkit.loadLibraries();
        Toolkit.initIDs();
    }

    private class SelectiveAWTEventListener
    implements AWTEventListener {
        AWTEventListener listener;
        private long eventMask;
        static final int LONG_BITS = 64;
        int[] calls = new int[64];

        public void orEventMasks(long l) {
            this.eventMask |= l;
            int n = 0;
            while (n < 64) {
                if (l == 0L) break;
                if ((l & 1L) != 0L) {
                    int n2 = n;
                    this.calls[n2] = this.calls[n2] + 1;
                }
                l >>>= 1;
                ++n;
            }
        }

        SelectiveAWTEventListener(AWTEventListener aWTEventListener, long l) {
            this.listener = aWTEventListener;
            this.eventMask = l;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            long l = 0L;
            l = this.eventMask & 1L;
            if (l != 0L && aWTEvent.id >= 100 && aWTEvent.id <= 103 || (l = this.eventMask & 2L) != 0L && aWTEvent.id >= 300 && aWTEvent.id <= 301 || (l = this.eventMask & 4L) != 0L && aWTEvent.id >= 1004 && aWTEvent.id <= 1005 || (l = this.eventMask & 8L) != 0L && aWTEvent.id >= 400 && aWTEvent.id <= 402 || (l = this.eventMask & 0x20L) != 0L && (aWTEvent.id == 503 || aWTEvent.id == 506) || (l = this.eventMask & 0x10L) != 0L && aWTEvent.id != 503 && aWTEvent.id != 506 && aWTEvent.id >= 500 && aWTEvent.id <= 506 || (l = this.eventMask & 0x40L) != 0L && aWTEvent.id >= 200 && aWTEvent.id <= 206 || (l = this.eventMask & 0x80L) != 0L && aWTEvent.id >= 1001 && aWTEvent.id <= 1001 || (l = this.eventMask & 0x100L) != 0L && aWTEvent.id >= 601 && aWTEvent.id <= 601 || (l = this.eventMask & 0x200L) != 0L && aWTEvent.id >= 701 && aWTEvent.id <= 701 || (l = this.eventMask & 0x400L) != 0L && aWTEvent.id >= 900 && aWTEvent.id <= 900 || (l = this.eventMask & 0x800L) != 0L && aWTEvent.id >= 1100 && aWTEvent.id <= 1101 || (l = this.eventMask & 0x2000L) != 0L && aWTEvent.id >= 800 && aWTEvent.id <= 801 || (l = this.eventMask & 0x4000L) != 0L && aWTEvent.id >= 1200 && aWTEvent.id <= 1200 || (l = this.eventMask & 0x8000L) != 0L && aWTEvent.id == 1400 || (l = this.eventMask & 0x10000L) != 0L && (aWTEvent.id == 1401 || aWTEvent.id == 1402)) {
                int n = (int)(Math.log(l) / Math.log(2.0));
                int n2 = 0;
                while (n2 < this.calls[n]) {
                    this.listener.eventDispatched(aWTEvent);
                    ++n2;
                }
            }
        }
    }

    private static class ToolkitEventMulticaster
    extends AWTEventMulticaster
    implements AWTEventListener {
        ToolkitEventMulticaster(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            super(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener add(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            if (aWTEventListener == null) {
                return aWTEventListener2;
            }
            if (aWTEventListener2 == null) {
                return aWTEventListener;
            }
            return new ToolkitEventMulticaster(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener remove(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            return (AWTEventListener)AWTEventMulticaster.removeInternal(aWTEventListener, aWTEventListener2);
        }

        protected EventListener remove(EventListener eventListener) {
            if (eventListener == this.a) {
                return this.b;
            }
            if (eventListener == this.b) {
                return this.a;
            }
            AWTEventListener aWTEventListener = (AWTEventListener)AWTEventMulticaster.removeInternal(this.a, eventListener);
            AWTEventListener aWTEventListener2 = (AWTEventListener)AWTEventMulticaster.removeInternal(this.b, eventListener);
            if (aWTEventListener == this.a && aWTEventListener2 == this.b) {
                return this;
            }
            return ToolkitEventMulticaster.add(aWTEventListener, aWTEventListener2);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            ((AWTEventListener)this.a).eventDispatched(aWTEvent);
            ((AWTEventListener)this.b).eventDispatched(aWTEvent);
        }
    }
}

