/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.highlight");
        this.lightHighlight = UIManager.getColor("TabbedPane.lightHighlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getTabCount();
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        Insets insets = this.tabPane.getInsets();
        int n4 = this.runCount - 1;
        while (n4 >= 0) {
            int n5 = this.tabRuns[n4];
            int n6 = this.tabRuns[n4 == this.runCount - 1 ? 0 : n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n3 - 1;
            int n8 = n5;
            while (n8 <= n7) {
                if (this.rects[n8].intersects(rectangle3)) {
                    this.paintTab(graphics, n2, this.rects, n8, rectangle, rectangle2);
                }
                ++n8;
            }
            --n4;
        }
        if (n >= 0 && this.getRunForTab(n3, n) == 0 && this.rects[n].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n, rectangle, rectangle2);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        String string = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        View view;
        graphics.setFont(font);
        if (this.htmlViews != null && (view = (View)this.htmlViews.elementAt(n2)) != null) {
            view.paint(graphics, rectangle);
        } else if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
            graphics.setColor(this.tabPane.getForegroundAt(n2));
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
            graphics.drawString(string, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = rectangle.width % 2;
            }
        }
        return n3;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.lightHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                break;
            }
            default: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.tabPane.getBackgroundAt(n2));
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 3, n6 - 1);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.lightHighlight);
        if (n != 1 || n2 < 0 || this.rects[n2].y + this.rects[n2].height + 1 < n4) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.lightHighlight);
        if (n != 2 || n2 < 0 || this.rects[n2].x + this.rects[n2].width + 1 < n3) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4, n3, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3, rectangle.y + rectangle.height, n3, n4 + n6 - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        if (n != 3 || n2 < 0 || this.rects[n2].y - 1 > n6) {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3 + 1, n4 + n6 - 2, rectangle.x - 1, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        if (n != 4 || n2 < 0 || this.rects[n2].x - 1 > n5) {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, rectangle.y + rectangle.height, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        return new Rectangle(this.rects[n]);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            if (this.rects[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent == component) {
            return;
        }
        if (this.visibleComponent != null) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            int n3 = n2;
            while (n3 < n) {
                this.rects[n3] = new Rectangle();
                ++n3;
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        int n3 = 0;
        while (n3 < this.runCount) {
            int n4 = this.tabRuns[n3];
            int n5 = this.lastTabInRun(n, n3);
            if (n2 >= n4 && n2 <= n5) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this.runCount - 1 ? 0 : n2 + 1;
        if (this.tabRuns[n3] == 0) {
            return n - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        return (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n)) && this.tabPane.getDisabledIconAt(n) != null ? this.tabPane.getDisabledIconAt(n) : this.tabPane.getIconAt(n);
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        View view;
        int n4 = 0;
        n4 = this.htmlViews != null && (view = (View)this.htmlViews.elementAt(n2)) != null ? (n4 += (int)view.getPreferredSpan(1)) : (n4 += n3);
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        while (n5 < n2) {
            n3 = Math.max(this.calculateTabHeight(n, n5, n4), n3);
            ++n5;
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 3;
        if (icon != null) {
            n3 += icon.getIconWidth() + this.textIconGap;
        }
        if (this.htmlViews != null && (view = (View)this.htmlViews.elementAt(n2)) != null) {
            n3 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n2);
            n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = Math.max(this.calculateTabWidth(n, n4, fontMetrics), n3);
            ++n4;
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabCount();
        block0 : switch (n2) {
            case 2: 
            case 4: {
                switch (n) {
                    case 1: {
                        this.selectPreviousTab(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTab(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        this.selectNextTab(n3);
                        break block0;
                    }
                    case 7: {
                        this.selectPreviousTab(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this.tabPane.setSelectedIndex(n4);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n4 = bl ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this.tabPane.getTabCount();
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.right;
                insets2.left = insets.top;
                insets2.bottom = insets.left;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.right;
                insets2.bottom = insets.top;
                insets2.right = insets.left;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector vector = new Vector();
        int n = this.tabPane.getTabCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string = this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                } else {
                    vector.addElement(null);
                }
                ++n2;
            }
        }
        return vector;
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component;
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            String string = jTabbedPane.getTitleAt(n = jTabbedPane.indexOfComponent(component = containerEvent.getChild()));
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            int n = jTabbedPane.indexOfComponent(component);
            if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() >= n) {
                BasicTabbedPaneUI.this.htmlViews.removeElementAt(n);
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            if (n > 0 && n == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[jTabbedPane.getSelectedIndex()]);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            if (n > 0 && n == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[jTabbedPane.getSelectedIndex()]);
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if (!jTabbedPane.isEnabled()) {
                return;
            }
            int n = BasicTabbedPaneUI.this.tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                if (n == jTabbedPane.getSelectedIndex()) {
                    jTabbedPane.requestFocus();
                    jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[n]);
                } else {
                    jTabbedPane.setSelectedIndex(n);
                }
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl) {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            Dimension dimension = new Dimension(0, 0);
            int n2 = insets2.top + insets2.bottom;
            int n3 = insets2.left + insets2.right;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n6);
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 != null) {
                    n5 = Math.max(dimension2.height, n5);
                    n4 = Math.max(dimension2.width, n4);
                }
                ++n6;
            }
            n3 += n4;
            n2 += n5;
            int n7 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    n7 = this.preferredTabAreaWidth(n, n2);
                    n3 += n7;
                    break;
                }
                default: {
                    n7 = this.preferredTabAreaHeight(n, n3);
                    n2 += n7;
                }
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabWidth(n, n8, fontMetrics);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabHeight(n, n8, n7);
                    if (n6 != 0 && n6 + n9 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n9;
                    ++n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, n5, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n4;
        }

        public void layoutContainer(Container container) {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n2 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n2 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n3 = 0;
                int n4 = 0;
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n2);
                boolean bl = false;
                if (component2 != null && component2 != component) {
                    if (component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    switch (n) {
                        case 2: {
                            n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + n3 + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n7 = insets.left + insets2.left;
                            n6 = insets.top + n4 + insets2.top;
                        }
                    }
                    int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                    int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    int n10 = 0;
                    while (n10 < n5) {
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(n10);
                        component3.setBounds(n7, n6, n8, n9);
                        ++n10;
                    }
                }
                if (bl && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int n = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n);
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            int n7 = fontMetrics.getHeight();
            int n8 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n9 = BasicTabbedPaneUI.this.getTabRunOverlay(n);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            int n10 = 0;
            while (n10 < n2) {
                rectangle = BasicTabbedPaneUI.this.rects[n10];
                if (!bl) {
                    if (n10 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n10 - 1].x + BasicTabbedPaneUI.this.rects[n10 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n10, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n10;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n10 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n10, n7);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n10;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n10 == n8) {
                    BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                }
                ++n10;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n5 : n6, n4);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n2, n8);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            n10 = BasicTabbedPaneUI.this.runCount - 1;
            while (n10 >= 0) {
                int n11;
                int n12;
                n3 = BasicTabbedPaneUI.this.tabRuns[n10];
                int n13 = BasicTabbedPaneUI.this.tabRuns[n10 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n10 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n11];
                        rectangle.y = n5;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n5 = n == 3 ? (n5 -= BasicTabbedPaneUI.this.maxTabHeight - n9) : (n5 += BasicTabbedPaneUI.this.maxTabHeight - n9);
                } else {
                    n11 = n3;
                    while (n11 <= n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n11];
                        rectangle.x = n6;
                        rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n, n10);
                        ++n11;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n10)) {
                        this.padTabRun(n, n3, n12, n4);
                    }
                    n6 = n == 4 ? (n6 -= BasicTabbedPaneUI.this.maxTabWidth - n9) : (n6 += BasicTabbedPaneUI.this.maxTabWidth - n9);
                }
                --n10;
            }
            this.padSelectedTab(n, n8);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                n10 = 0;
                while (n10 < n2) {
                    BasicTabbedPaneUI.this.rects[n10].x = n3 - BasicTabbedPaneUI.this.rects[n10].x - BasicTabbedPaneUI.this.rects[n10].width;
                    ++n10;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = BasicTabbedPaneUI.this.tabRuns[0];
                int n5 = 1;
                while (n5 < BasicTabbedPaneUI.this.runCount) {
                    BasicTabbedPaneUI.this.tabRuns[n5 - 1] = BasicTabbedPaneUI.this.tabRuns[n5];
                    ++n5;
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n4;
                ++n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            boolean bl = n == 2 || n == 4;
            int n5 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl2 = true;
            double d = 1.25;
            while (bl2) {
                int n6;
                int n7;
                int n8 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5);
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                if (!bl) {
                    n7 = BasicTabbedPaneUI.this.rects[n8].x + BasicTabbedPaneUI.this.rects[n8].width;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d);
                } else {
                    n7 = BasicTabbedPaneUI.this.rects[n8].y + BasicTabbedPaneUI.this.rects[n8].height;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d * 2.0);
                }
                if (n4 - n7 > n6) {
                    BasicTabbedPaneUI.this.tabRuns[n5] = n9;
                    if (!bl) {
                        BasicTabbedPaneUI.this.rects[n9].x = n3;
                    } else {
                        BasicTabbedPaneUI.this.rects[n9].y = n3;
                    }
                    int n10 = n9 + 1;
                    while (n10 <= n8) {
                        if (!bl) {
                            BasicTabbedPaneUI.this.rects[n10].x = BasicTabbedPaneUI.this.rects[n10 - 1].x + BasicTabbedPaneUI.this.rects[n10 - 1].width;
                        } else {
                            BasicTabbedPaneUI.this.rects[n10].y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                        }
                        ++n10;
                    }
                } else if (n5 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl2 = false;
                }
                if (n5 - 1 > 0) {
                    --n5;
                    continue;
                }
                n5 = BasicTabbedPaneUI.this.runCount - 1;
                d += 0.25;
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                int n7 = n2;
                while (n7 <= n3) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[n7];
                    if (n7 > n2) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[n7 - 1].x + BasicTabbedPaneUI.this.rects[n7 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                    ++n7;
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n2].y;
                int n9 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n9 / (float)n8;
                int n10 = n2;
                while (n10 <= n3) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[n10];
                    if (n10 > n2) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                    ++n10;
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
            if (n2 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n2];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

