/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        this.changeListener = this.createChangeListener(this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.menuListener = this.createMenuListener(this.menuItem);
        this.menuItem.addChangeListener(this.changeListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        if (n == this.lastMnemonic) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(KeyStroke.getKeyStroke(n, 8, false), "selectMenu");
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
            ActionMap actionMap2 = (ActionMap)UIManager.get("Menu.sharedActionMap");
            if (actionMap2 == null && (actionMap2 = this.createSharedActionMap()) != null) {
                UIManager.put("MenuUI.sharedActionMap", actionMap2);
            }
            if (actionMap2 != null) {
                actionMap.setParent(actionMap2);
            }
        }
        return actionMap;
    }

    ActionMap createSharedActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("cancel", new CancelAction());
        actionMapUIResource.put("selectNext", new SelectNextItemAction());
        actionMapUIResource.put("selectPrevious", new SelectPreviousItemAction());
        actionMapUIResource.put("selectParent", new SelectParentItemAction());
        actionMapUIResource.put("selectChild", new SelectChildItemAction());
        actionMapUIResource.put("return", new ReturnAction());
        return actionMapUIResource;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler((JMenu)jComponent, this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            int n = BasicMenuUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower(n) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu = ((JMenu)BasicMenuUI.this.menuItem).getPopupMenu();
                MenuElement[] menuElementArray2 = jPopupMenu.getSubElements();
                if (menuElementArray2.length > 0) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = jPopupMenu;
                    menuElementArray3[menuElementArray.length + 1] = menuElementArray2[0];
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                }
                menuKeyEvent.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private int lower(int n) {
            if (n >= 65 && n <= 90) {
                return n + 97 - 65;
            }
            return n;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!BasicMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    private static class SelectChildItemAction
    extends AbstractAction {
        private SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu = (JMenu)actionEvent.getSource();
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                if (menuElementArray3.length > 0) {
                    menuElementArray2[menuElementArray.length + 1] = BasicMenuUI.nextEnabledChild(menuElementArray3, 0);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray4;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray4 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n2 = menuElementArray4.length;
                    while (n < n2) {
                        if (menuElementArray4[n] == menuElementArray[1] && (menuElement = BasicMenuUI.nextEnabledChild(menuElementArray4, n + 1)) == null) {
                            menuElement = BasicMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray4 = jPopupMenu.getSubElements();
                        if (menuElementArray4.length > 0) {
                            menuElement2 = BasicMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                    }
                    MenuElement[] menuElementArray5 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                }
            }
        }
    }

    private static class SelectParentItemAction
    extends AbstractAction {
        private SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu = (JMenu)actionEvent.getSource();
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray3;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray3 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n2 = menuElementArray3.length;
                    while (n < n2) {
                        if (menuElementArray3[n] == menuElementArray[1] && (menuElement = BasicMenuUI.previousEnabledChild(menuElementArray3, n - 1)) == null) {
                            menuElement = BasicMenuUI.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray3 = jPopupMenu.getSubElements();
                        if (menuElementArray3.length > 0) {
                            menuElement2 = BasicMenuUI.nextEnabledChild(menuElementArray3, 0);
                        }
                    }
                    MenuElement[] menuElementArray4 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                }
            }
        }
    }

    private static class SelectPreviousItemAction
    extends AbstractAction {
        private SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block5: {
                    JMenu jMenu = (JMenu)actionEvent.getSource();
                    if (!jMenu.isEnabled()) {
                        return;
                    }
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block5;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block4;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicMenuUI.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                    if (menuElementArray3[menuElementArray.length] == null) break block4;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block4;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = BasicMenuUI.previousEnabledChild(menuElementArray4, n - 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicMenuUI.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        private SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block5: {
                    JMenu jMenu = (JMenu)actionEvent.getSource();
                    if (!jMenu.isEnabled()) {
                        return;
                    }
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block5;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block4;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicMenuUI.nextEnabledChild(menuElementArray2, 0);
                    if (menuElementArray3[menuElementArray.length] == null) break block4;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block4;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = BasicMenuUI.nextEnabledChild(menuElementArray4, n + 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private static class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu = (JMenu)actionEvent.getSource();
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ((JMenuItem)menuElement).doClick(0);
                    ((JMenuItem)menuElement).setArmed(false);
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu = (JMenu)actionEvent.getSource();
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public BasicMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.menu = jMenu;
            this.ui = basicMenuUI2;
            this.validateKeyboardActions(this.menu.isSelected());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.validateKeyboardActions(this.menu.isSelected());
        }

        private Component findFocusedComponent(Component component) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Window) {
                    return ((Window)container).getFocusOwner();
                }
                container = container.getParent();
            }
            return null;
        }

        private void validateKeyboardActions(boolean bl) {
            if (bl != this.isSelected) {
                this.isSelected = bl;
                if (this.isSelected) {
                    Object[] objectArray;
                    boolean bl2 = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (this.wasFocused instanceof JComponent && ((JComponent)this.wasFocused).getRootPane() != this.menu.getRootPane()) {
                        this.wasFocused = null;
                    }
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    if (BasicMenuUI.this.selectedWindowInputMap == null && (objectArray = (Object[])UIManager.get("Menu.selectedWindowInputMapBindings")) != null) {
                        BasicMenuUI.this.selectedWindowInputMap = LookAndFeel.makeComponentInputMap(BasicMenuUI.this.menuItem, objectArray);
                    }
                    if (BasicMenuUI.this.windowInputMap == null) {
                        BasicMenuUI.this.windowInputMap = BasicMenuUI.this.createInputMap(2);
                        SwingUtilities.replaceUIInputMap(BasicMenuUI.this.menuItem, 2, BasicMenuUI.this.windowInputMap);
                    }
                    if (BasicMenuUI.this.windowInputMap != null && BasicMenuUI.this.selectedWindowInputMap != null) {
                        BasicMenuUI.this.windowInputMap.setParent(BasicMenuUI.this.selectedWindowInputMap);
                    }
                } else {
                    if (BasicMenuUI.this.windowInputMap != null && BasicMenuUI.this.selectedWindowInputMap != null) {
                        BasicMenuUI.this.windowInputMap.setParent(null);
                    }
                    if (this.wasFocused != null) {
                        if (this.wasFocused instanceof JComponent) {
                            JComponent jComponent = (JComponent)this.wasFocused;
                            boolean bl3 = jComponent.isRequestFocusEnabled();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(true);
                            }
                            this.wasFocused.requestFocus();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(false);
                            }
                        } else {
                            this.wasFocused.requestFocus();
                        }
                        this.wasFocused = null;
                    }
                }
            }
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuSelected(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray;
            Object object;
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length <= 0 || object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    menuElementArray = new MenuElement[((MenuElement[])object).length + 1];
                    System.arraycopy(object, 0, menuElementArray, 0, ((MenuElement[])object).length);
                    menuElementArray[((MenuElement[])object).length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    BasicMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                        menuElementArray2[menuElementArray.length] = BasicMenuUI.this.menuItem;
                        menuElementArray2[menuElementArray.length + 1] = jMenu.getPopupMenu();
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    } else {
                        menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray3 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray3);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                BasicMenuUI.this.updateMnemonicBinding();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    menuSelectionManager.clearSelectedPath();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = this.menu.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

