/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Handouts
extends AbstractTool {
    public Handouts() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pages", "The number of pages you want on one handout page");
        optionArgument.addOption("2 pages on 1", "2");
        optionArgument.addOption("3 pages on 1", "3");
        optionArgument.addOption("4 pages on 1", "4");
        optionArgument.addOption("5 pages on 1", "5");
        optionArgument.addOption("6 pages on 1", "6");
        optionArgument.addOption("7 pages on 1", "7");
        optionArgument.addOption("8 pages on 1", "8");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Handouts", true, true, true);
        this.internalFrame.setSize(300, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(20, 10));
    }

    public void execute() {
        try {
            int n;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            try {
                n = Integer.parseInt((String)this.getValue("pages"));
            }
            catch (Exception exception) {
                n = 4;
            }
            float f = 30.0f;
            float f2 = 280.0f;
            float f3 = 320.0f;
            float f4 = 565.0f;
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            float f5 = (778.0f - 20.0f * (float)(n - 1)) / (float)n;
            fArray[0] = 812.0f;
            fArray2[0] = 812.0f - f5;
            for (int i = 1; i < n; ++i) {
                fArray[i] = fArray2[i - 1] - 20.0f;
                fArray2[i] = fArray[i] - f5;
            }
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n2 = pdfReader.getNumberOfPages();
            System.out.println("There are " + n2 + " pages in the original file.");
            Document document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                float f6;
                Rectangle rectangle;
                float f7;
                float f8 = (f7 = (f2 - f) / (rectangle = pdfReader.getPageSizeWithRotation(++n3)).width()) < (f6 = (fArray[n4] - fArray2[n4]) / rectangle.height()) ? f7 : f6;
                float f9 = f7 == f8 ? 0.0f : (f2 - f - rectangle.width() * f8) / 2.0f;
                float f10 = f6 == f8 ? 0.0f : (fArray[n4] - fArray2[n4] - rectangle.height() * f8) / 2.0f;
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n3);
                int n5 = pdfReader.getPageRotation(n3);
                if (n5 == 90 || n5 == 270) {
                    pdfContentByte.addTemplate(pdfImportedPage, 0.0f, -f8, f8, 0.0f, f + f9, fArray2[n4] + f10 + rectangle.height() * f8);
                } else {
                    pdfContentByte.addTemplate(pdfImportedPage, f8, 0.0f, 0.0f, f8, f + f9, fArray2[n4] + f10);
                }
                pdfContentByte.setRGBColorStroke(192, 192, 192);
                pdfContentByte.rectangle(f3 - 5.0f, fArray2[n4] - 5.0f, f4 - f3 + 10.0f, fArray[n4] - fArray2[n4] + 10.0f);
                for (float f11 = fArray[n4] - 19.0f; f11 > fArray2[n4]; f11 -= 16.0f) {
                    pdfContentByte.moveTo(f3, f11);
                    pdfContentByte.lineTo(f4, f11);
                }
                pdfContentByte.rectangle(f + f9, fArray2[n4] + f10, rectangle.width() * f8, rectangle.height() * f8);
                pdfContentByte.stroke();
                System.out.println("Processed page " + n3);
                if (++n4 != n) continue;
                n4 = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Handouts handouts = new Handouts();
        if (stringArray.length < 2) {
            System.err.println(handouts.getUsage());
        }
        handouts.setArguments(stringArray);
        handouts.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Handouts.addVersion("$Id: Handouts.java,v 1.4 2005/08/29 09:21:56 blowagie Exp $");
    }
}

