/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

public class Proxy
implements Serializable {
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = Proxy.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    private static Map loaderToCache = new WeakHashMap(3);
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map proxyClasses = Collections.synchronizedMap(new WeakHashMap(3));
    protected InvocationHandler h;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.h = invocationHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class getProxyClass(ClassLoader classLoader, Class[] classArray) throws IllegalArgumentException {
        Map map;
        Object object;
        Map map2;
        Object object2;
        Class clazz = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (n >= classArray.length) {
                object2 = stringBuffer.toString();
                Map map3 = loaderToCache;
                synchronized (map3) {
                    map2 = (Map)loaderToCache.get(classLoader);
                    if (map2 == null) {
                        map2 = new HashMap(3);
                        loaderToCache.put(classLoader, map2);
                    }
                }
                Map map4 = map2;
                synchronized (map4) {
                    break;
                }
            }
            object2 = null;
            try {
                object2 = Class.forName(classArray[n].getName(), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object2 != classArray[n]) {
                throw new IllegalArgumentException(classArray[n] + " is not visible from class loader");
            }
            if (!((Class)object2).isInterface()) {
                throw new IllegalArgumentException(((Class)object2).getName() + " is not an interface");
            }
            stringBuffer.append(classArray[n].getName()).append(';');
            ++n;
        }
        {
            while (true) {
                if ((object = map2.get(object2)) instanceof Reference) {
                    clazz = (Class)((Reference)object).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (object != pendingGenerationMarker) break;
                try {
                    map2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            map2.put(object2, pendingGenerationMarker);
        }
        try {
            object = null;
            int n2 = 0;
            while (true) {
                if (n2 >= classArray.length) {
                    long l;
                    if (object == null) {
                        object = "";
                    }
                    Object object3 = nextUniqueNumberLock;
                    synchronized (object3) {
                        l = nextUniqueNumber++;
                    }
                    String string = (String)object + proxyClassNamePrefix + l;
                    byte[] byArray = ProxyGenerator.generateProxyClass(string, classArray);
                    try {
                        clazz = Proxy.defineClass0(classLoader, string, byArray, 0, byArray.length);
                        break;
                    }
                    catch (ClassFormatError classFormatError) {
                        throw new IllegalArgumentException(classFormatError.toString());
                    }
                }
                int n3 = classArray[n2].getModifiers();
                if (!Modifier.isPublic(n3)) {
                    String string;
                    String string2 = classArray[n2].getName();
                    int n4 = string2.lastIndexOf(46);
                    String string3 = string = n4 == -1 ? "" : string2.substring(0, n4 + 1);
                    if (object == null) {
                        object = string;
                    } else if (!string.equals(object)) {
                        throw new IllegalArgumentException("non-public interfaces from different packages");
                    }
                }
                ++n2;
            }
            proxyClasses.put(clazz, null);
            Object var19_23 = null;
            map = map2;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            Map map5 = map2;
            synchronized (map5) {
                if (clazz != null) {
                    map2.put(object2, new WeakReference(clazz));
                } else {
                    map2.remove(object2);
                }
                map2.notifyAll();
                throw throwable;
            }
        }
        synchronized (map) {
            if (clazz != null) {
                map2.put(object2, new WeakReference(clazz));
            } else {
                map2.remove(object2);
            }
            map2.notifyAll();
            return clazz;
        }
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            Constructor constructor = clazz.getConstructor(constructorParams);
            return constructor.newInstance(new Object[]{invocationHandler});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }

    public static boolean isProxyClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

